/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.vterm;

import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.common.util.HardwareServerMessage;
import com.ibm.hsc.common.util.HardwareServerUtilities;
import com.ibm.hsc.common.util.IPSlipUtil;
import com.ibm.hsc.common.util.SLICSerialCommandMessage;
import com.ibm.hsc.vterm.VSerialInfoClient;
import com.ibm.hsc.vterm.VSerialPartitionInfo;
import com.ibm.hsc.vterm.VSerialSessionIfc;
import com.ibm.hsc.vterm.VSerialSystemInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.BitSet;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class VSerialHelper {
    private static final String TIMEOUT_PROPS_FILE = "/opt/hsc/data/hmc.properties";
    private static final String TIMEOUT_SURV_KEY = "Os400ConsoleConnMonitoringInSec";
    public static final long SURVEILLANCE_INTERVAL_SEC;
    public static final long SURVEILLANCE_INTERVAL_MS;
    private static final long DEFAULT_SURVEILLANCE_TIMEOUT_SEC = 200L;
    private static final long MIN_SURVEILLANCE_TIMEOUT_SEC = 6L;
    public static final long NO_CORRELATION = 0xFFFFFFL;
    public static final long MAX_CORRELATION = 65535L;
    public static final long TODO_CORRELATION = 49087L;
    public static final int SEVERE_ERROR = 65535;
    public static final int INPUT_SYNTAX_ERROR = 65534;
    public static final int HARDWARE_SERVER_COMM_ERROR = 65533;
    public static final int AUTHENTICATION_ERROR = 65532;
    public static final int SURVEILLANCE_FAILED = 65531;
    public static final int NO_DATA_ERROR = 0;
    private static final int SLIC_RC_64 = 258;
    public static final int VSERIAL_STATE_DOWN = 0;
    public static final int VSERIAL_STATE_XOFF = 1;
    public static final int VSERIAL_STATE_UP = 2;
    public static final String s_prompt = "vshelper> ";
    public static final String s_authCommand = "auth";
    public static final String s_logoutCommand = "logout";
    public static final String s_getSystemInformationCommand = "sysinfo";
    public static final String s_getPartitionInformationCommand = "ptninfo";
    public static final String s_openSessionCommand = "open-serial";
    public static final String s_closeSessionCommand = "close-serial";
    public static final String s_listSessionsCommand = "list-serial";
    public static final String s_initConsoleDaemonCommand = "init-cond";
    public static final String s_slicEchoCommand = "slic-echo";
    public static final String s_slicSurveillanceCommand = "slic-surveillance";
    public static final String s_writeTextCommand = "writetext";
    public static final String s_sendSlicCommand = "sendslic";
    public static final String s_setTraceLevelCommand = "trace";
    public static final String s_dumpStateCommand = "dump-state";
    public static final String s_getHelpCommand = "help";
    public static final String s_exitCommand = "exit";
    static boolean s_allowRoot;
    static boolean s_useCIM;
    private String m_hdwrSvrIpAddress;
    private Socket m_hdwr_svrSocket;
    private HardwareServerUtilities m_hdwr_svrUtil;
    private DataInputStream m_socketInput;
    private DataOutputStream m_socketOutput;
    private boolean m_needToStopSockListener = false;
    private int m_correlationIncrementer = 1;
    private Hashtable m_sessionMap;
    private Map m_surveillanceMap = new HashMap();
    private Hashtable m_correlationTokenMap;
    private Map m_upMap;
    public static boolean logTrace;
    public static boolean logComm;
    public static boolean logCIMExceptions;
    private static PrintStream outputPrintStream;
    private static PrintStream asyncPrintStream;

    static Long generateKey(int n, int n2, int n3) {
        long l = ((long)n & 0xFFFFFFFFFFFFFFFFL) << 32 | ((long)n2 & 0xFFFFL) << 16 | (long)n3 & 0xFFFFL;
        return new Long(l);
    }

    private synchronized int getNextCorrelationToken() {
        int n = 1;
        while ((long)n < 65535L) {
            ++this.m_correlationIncrementer;
            if ((long)this.m_correlationIncrementer >= 65535L) {
                this.m_correlationIncrementer = 1;
            }
            if (!this.m_correlationTokenMap.containsKey(new Integer(this.m_correlationIncrementer))) {
                this.m_correlationTokenMap.put(new Integer(this.m_correlationIncrementer), new CorrelationTokenMapEntry(null, null));
                return this.m_correlationIncrementer;
            }
            ++n;
        }
        throw new RuntimeException("No available correlation tokens.  Aborting.");
    }

    private synchronized int getCurrCorrelationToken() {
        return this.m_correlationIncrementer;
    }

    private synchronized void startSurveillance(int n, int n2, int n3) {
        Long l = VSerialHelper.generateKey(n, n2, n3);
        this.m_surveillanceMap.put(l, null);
    }

    private synchronized void stopSurveillance(int n, int n2, int n3) {
        this.stopSurveillance(VSerialHelper.generateKey(n, n2, n3));
    }

    private synchronized void stopSurveillance(Long l) {
        this.m_surveillanceMap.remove(l);
    }

    private synchronized Date getSurveillanceDate(Long l) {
        return (Date)this.m_surveillanceMap.get(l);
    }

    private synchronized void setSurveillanceDate(Long l, Date date) {
        if (this.m_surveillanceMap.containsKey(l)) {
            this.m_surveillanceMap.put(l, date);
        }
    }

    private synchronized Vector getSurveillanceKeyList() {
        Set set = this.m_surveillanceMap.keySet();
        Iterator iterator = set.iterator();
        Vector<Long> vector = new Vector<Long>();
        while (iterator.hasNext()) {
            Long l = (Long)iterator.next();
            if (l == null) continue;
            vector.add(l);
        }
        return vector;
    }

    static final void logError(long l, long l2, String string) {
        VSerialHelper.logTrace("");
        asyncPrintStream.println("\nError Response: " + Long.toHexString(l));
        asyncPrintStream.println(Long.toHexString(l2) + " - " + string);
        asyncPrintStream.println("Response Complete");
    }

    static final void logResponseHeader(long l) {
        VSerialHelper.logTrace("");
        asyncPrintStream.println("Response: " + Long.toHexString(l));
    }

    static final void logResponseTrailer() {
        VSerialHelper.logTrace("");
        asyncPrintStream.println("Response Complete");
    }

    static final void logResponseMsg(long l, String string) {
        VSerialHelper.logResponseHeader(l);
        asyncPrintStream.println(string);
        VSerialHelper.logResponseTrailer();
        asyncPrintStream.flush();
    }

    static final void logTrace(String string) {
        if (logTrace) {
            System.out.println("TRC: " + new Date() + ": " + string);
            System.out.flush();
        }
    }

    static final void logComm(String string) {
        if (logComm) {
            System.out.println("CMM: " + new Date() + ": " + string);
            System.out.flush();
        }
    }

    static final void logCIMException(Exception exception) {
        if (logCIMExceptions) {
            System.err.println("CIM: " + new Date());
            exception.printStackTrace();
        }
    }

    static final void printOutput(String string) {
        outputPrintStream.print(string);
        outputPrintStream.flush();
    }

    static void setTraceLevel(int n) {
        logComm = (n & 1) != 0;
        logTrace = (n & 2) != 0;
        logCIMExceptions = (n & 4) != 0;
    }

    public static void main(String[] stringArray) {
        String string = "localhost";
        System.out.println("User = '" + System.getProperty("user.name") + "'");
        for (int i = 0; i < stringArray.length; ++i) {
            if ("--ip".equals(stringArray[i])) {
                VSerialHelper.logTrace("--ip = " + stringArray[++i]);
                string = stringArray[i];
                continue;
            }
            if ("--out".equals(stringArray[i])) {
                ++i;
                try {
                    VSerialHelper.logTrace("--out = " + stringArray[i]);
                    FileOutputStream fileOutputStream = new FileOutputStream(stringArray[i]);
                    outputPrintStream = new PrintStream(fileOutputStream, true);
                }
                catch (Exception exception) {
                    VSerialHelper.logError(0xFFFFFFL, 65535L, "Exception with outfile: " + exception);
                    exception.printStackTrace();
                    System.exit(1);
                }
                continue;
            }
            if ("--async".equals(stringArray[i])) {
                ++i;
                try {
                    VSerialHelper.logTrace("--async = " + stringArray[i]);
                    FileOutputStream fileOutputStream = new FileOutputStream(stringArray[i]);
                    asyncPrintStream = new PrintStream(fileOutputStream, true);
                }
                catch (Exception exception) {
                    VSerialHelper.logError(0xFFFFFFL, 65535L, "Exception with asyncfile: " + exception);
                    exception.printStackTrace();
                    System.exit(1);
                }
                continue;
            }
            if ("--allowroot".equals(stringArray[i])) {
                s_allowRoot = true;
                continue;
            }
            if ("--nocim".equals(stringArray[i])) {
                s_useCIM = false;
                continue;
            }
            if (!"--trace".equals(stringArray[i])) continue;
            ++i;
            try {
                int n = Integer.parseInt(stringArray[i], 16);
                VSerialHelper.setTraceLevel(n);
                continue;
            }
            catch (Exception exception) {
                VSerialHelper.logError(0xFFFFFFL, 65535L, "Exception with tracelevel: " + exception);
                exception.printStackTrace();
                System.exit(1);
            }
        }
        VSerialHelper.logTrace("ip,out,async: " + string + ", " + outputPrintStream + ", " + asyncPrintStream);
        outputPrintStream.println("Os400ConsoleConnMonitoringInSec " + SURVEILLANCE_INTERVAL_SEC);
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            VSerialHelper vSerialHelper = new VSerialHelper(string, true);
            SLICSurveillanceTask sLICSurveillanceTask = vSerialHelper.new SLICSurveillanceTask();
            Thread thread = new Thread(sLICSurveillanceTask);
            thread.start();
            vSerialHelper.m_hdwr_svrUtil = new HardwareServerUtilities(vSerialHelper.m_hdwrSvrIpAddress);
            while (true) {
                HardwareServerMessage hardwareServerMessage;
                short s;
                Object object;
                outputPrintStream.print(s_prompt);
                String string2 = bufferedReader.readLine();
                vSerialHelper.getNextCorrelationToken();
                outputPrintStream.println("Response token: " + Long.toHexString(vSerialHelper.getCurrCorrelationToken()));
                if (string2 == null) {
                    System.exit(2);
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                Vector<String> vector = new Vector<String>(stringTokenizer.countTokens());
                while (stringTokenizer.hasMoreTokens()) {
                    vector.add(stringTokenizer.nextToken());
                }
                if (vector.size() <= 0) continue;
                String string3 = (String)vector.get(0);
                if (s_authCommand.equals(string3)) {
                    VSerialHelper.logTrace("read: auth **** ****");
                    if (vector.size() == 3) {
                        String string4 = (String)vector.get(1);
                        String string5 = (String)vector.get(2);
                        try {
                            long l = vSerialHelper.getUPToken(string4, string5);
                            if (l != 0L) {
                                VSerialHelper.logResponseMsg(vSerialHelper.getCurrCorrelationToken(), "\"" + Long.toHexString(l) + "\"");
                                continue;
                            }
                            VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65532L, "authentication failed");
                        }
                        catch (SecurityException securityException) {
                            VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65532L, "authentication failed");
                        }
                        continue;
                    }
                    VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65534L, "invalid parms use the 'help' command");
                    continue;
                }
                if (s_logoutCommand.equals(string3)) {
                    VSerialHelper.logTrace("read: " + string2);
                    if (vector.size() == 2) {
                        try {
                            long l = 0L;
                            l = Long.parseLong((String)vector.get(1), 16);
                            vSerialHelper.m_upMap.remove(new Long(l));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        VSerialHelper.logResponseMsg(vSerialHelper.getCurrCorrelationToken(), "");
                        continue;
                    }
                    VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65534L, "invalid parms use the 'help' command");
                    continue;
                }
                if (s_getSystemInformationCommand.equals(string3)) {
                    VSerialHelper.logTrace("read: " + string2);
                    if (vector.size() == 2) {
                        long l = 0L;
                        try {
                            l = Long.parseLong((String)vector.get(1), 16);
                            VSerialSystemInfo[] vSerialSystemInfoArray = vSerialHelper.getSystemInformation(l);
                            if (vSerialSystemInfoArray == null || vSerialSystemInfoArray.length == 0) {
                                VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 0L, "no data to return");
                                continue;
                            }
                            VSerialHelper.logResponseHeader(vSerialHelper.getCurrCorrelationToken());
                            for (int i = 0; i < vSerialSystemInfoArray.length; ++i) {
                                asyncPrintStream.println(vSerialSystemInfoArray[i]);
                            }
                            VSerialHelper.logResponseTrailer();
                        }
                        catch (SecurityException securityException) {
                            VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65532L, securityException.toString());
                        }
                        catch (Exception exception) {
                            VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65535L, exception.toString());
                            exception.printStackTrace();
                        }
                        continue;
                    }
                    VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65534L, "invalid parms use the 'help' command");
                    continue;
                }
                if (s_getPartitionInformationCommand.equals(string3)) {
                    VSerialHelper.logTrace("read: " + string2);
                    if (vector.size() == 3) {
                        long l = 0L;
                        try {
                            l = Long.parseLong((String)vector.get(1), 16);
                            VSerialPartitionInfo[] vSerialPartitionInfoArray = null;
                            try {
                                vSerialPartitionInfoArray = vSerialHelper.getPartitionInformation(l, (String)vector.get(2));
                                if (vSerialPartitionInfoArray == null || vSerialPartitionInfoArray.length == 0) {
                                    VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 0L, "no data to return");
                                    continue;
                                }
                                VSerialHelper.logResponseHeader(vSerialHelper.getCurrCorrelationToken());
                                for (int i = 0; i < vSerialPartitionInfoArray.length; ++i) {
                                    asyncPrintStream.println(vSerialPartitionInfoArray[i].toString());
                                }
                                VSerialHelper.logResponseTrailer();
                            }
                            catch (UnsupportedOperationException unsupportedOperationException) {
                                vSerialHelper.sendGetPartitionInformation(l, (String)vector.get(2));
                            }
                        }
                        catch (SecurityException securityException) {
                            VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65532L, securityException.toString());
                        }
                        catch (Exception exception) {
                            VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65535L, exception.toString());
                            exception.printStackTrace();
                        }
                        continue;
                    }
                    VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65534L, "invalid parms use the 'help' command");
                    continue;
                }
                if (s_listSessionsCommand.equals(string3)) {
                    VSerialHelper.logTrace("read: " + string2);
                    if (vector.size() == 3) {
                        long l = 0L;
                        try {
                            l = Long.parseLong((String)vector.get(1), 16);
                            int n = Integer.parseInt((String)vector.get(2));
                            HardwareServerMessage hardwareServerMessage2 = HardwareServerMessage.buildVserialListRequest(n, vSerialHelper.getCurrCorrelationToken());
                            vSerialHelper.authenticate(l, n, 65535);
                            vSerialHelper.sendMessage(hardwareServerMessage2);
                        }
                        catch (IOException iOException) {
                            VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65533L, iOException.toString());
                        }
                        catch (SecurityException securityException) {
                            VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65532L, securityException.toString());
                        }
                        catch (Exception exception) {
                            VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65535L, exception.toString());
                        }
                        continue;
                    }
                    VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65534L, "invalid parms use the 'help' command");
                    continue;
                }
                if (s_openSessionCommand.equals(string3)) {
                    VSerialHelper.logTrace("read: " + string2);
                    if (vector.size() >= 3) {
                        long l = 0L;
                        try {
                            l = Long.parseLong((String)vector.get(1), 16);
                            int n = Integer.parseInt((String)vector.get(2));
                            short s2 = Short.parseShort((String)vector.get(3));
                            short s3 = 1;
                            vSerialHelper.authenticate(l, n, s2);
                            if (vector.size() > 4) {
                                s3 = Short.parseShort((String)vector.get(4));
                            }
                            short s4 = 0;
                            short s5 = 2;
                            if (vector.size() > 5 && "raw".equalsIgnoreCase((String)vector.get(5))) {
                                s5 = 1;
                            }
                            object = null;
                            if (vector.size() > 7) {
                                String string6 = (String)vector.get(6);
                                if ("ce".equalsIgnoreCase(string6)) {
                                    object = HardwareServerMessage.buildVserialAuthenticatedOpenRequest(n, vSerialHelper.getCurrCorrelationToken(), s2, s3, s4, s5, (byte)4, (String)vector.get(7));
                                } else if ("dev".equalsIgnoreCase(string6)) {
                                    object = HardwareServerMessage.buildVserialAuthenticatedOpenRequest(n, vSerialHelper.getCurrCorrelationToken(), s2, s3, s4, s5, (byte)4, (String)vector.get(7));
                                } else {
                                    VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65534L, "invalid parms use the 'help' command");
                                }
                            } else {
                                object = HardwareServerMessage.buildVserialOpenRequest(n, vSerialHelper.getCurrCorrelationToken(), s2, s3, s4, s5);
                            }
                            vSerialHelper.sendMessage((HardwareServerMessage)object);
                        }
                        catch (IOException iOException) {
                            VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65533L, iOException.toString());
                        }
                        catch (SecurityException securityException) {
                            VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65532L, securityException.toString());
                        }
                        catch (Exception exception) {
                            VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65535L, exception.toString());
                        }
                        continue;
                    }
                    VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65534L, "invalid parms use the 'help' command");
                    continue;
                }
                if (s_closeSessionCommand.equals(string3)) {
                    VSerialHelper.logTrace("read: " + string2);
                    if (vector.size() > 3) {
                        long l = 0L;
                        try {
                            l = Long.parseLong((String)vector.get(1), 16);
                            int n = Integer.parseInt((String)vector.get(2));
                            short s6 = Short.parseShort((String)vector.get(3));
                            short s7 = 1;
                            boolean bl = false;
                            if (vector.size() > 4) {
                                if ("FORCE".equalsIgnoreCase((String)vector.get(4))) {
                                    s7 = Short.parseShort((String)vector.get(4));
                                } else {
                                    bl = true;
                                }
                            }
                            if (vector.size() > 5 && "FORCE".equalsIgnoreCase((String)vector.get(5))) {
                                bl = true;
                            }
                            vSerialHelper.authenticate(l, n, s6);
                            vSerialHelper.stopSurveillance(n, s6, s7);
                            HardwareServerMessage hardwareServerMessage3 = HardwareServerMessage.buildVserialCloseRequest(n, vSerialHelper.getCurrCorrelationToken(), s6, s7, bl);
                            vSerialHelper.sendMessage(hardwareServerMessage3);
                        }
                        catch (IOException iOException) {
                            VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65533L, iOException.toString());
                        }
                        catch (SecurityException securityException) {
                            VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65532L, securityException.toString());
                        }
                        catch (Exception exception) {
                            VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65535L, exception.toString());
                        }
                        continue;
                    }
                    VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65534L, "invalid parms use the 'help' command");
                    continue;
                }
                if (s_writeTextCommand.equals(string3)) {
                    VSerialHelper.logTrace("read: " + string2);
                    if (vector.size() == 5) {
                        try {
                            int n = Integer.parseInt((String)vector.get(1));
                            s = Short.parseShort((String)vector.get(2));
                            short s8 = Short.parseShort((String)vector.get(3));
                            String string7 = (String)vector.get(4);
                            byte[] byArray = string7.getBytes();
                            byte[] byArray2 = new byte[byArray.length + 2];
                            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                            byArray2[byArray.length] = 13;
                            byArray2[byArray.length + 1] = 10;
                            HardwareServerMessage hardwareServerMessage4 = HardwareServerMessage.buildVserialWrite(n, vSerialHelper.getCurrCorrelationToken(), s, s8, byArray2, byArray2.length);
                            vSerialHelper.sendMessage(hardwareServerMessage4);
                        }
                        catch (IOException iOException) {
                            VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65533L, iOException.toString());
                        }
                        catch (SecurityException securityException) {
                            VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65532L, securityException.toString());
                        }
                        catch (Exception exception) {
                            VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65535L, exception.toString());
                        }
                        continue;
                    }
                    VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65534L, "invalid parms use the 'help' command");
                    continue;
                }
                if (s_initConsoleDaemonCommand.equals(string3)) {
                    VSerialHelper.logTrace("read: " + string2);
                    if (vector.size() >= 4) {
                        long l = 0L;
                        try {
                            l = Long.parseLong((String)vector.get(1), 16);
                            int n = Integer.parseInt((String)vector.get(2));
                            short s9 = Short.parseShort((String)vector.get(3));
                            vSerialHelper.authenticate(l, n, s9);
                            short s10 = 1;
                            boolean bl = false;
                            if (vector.size() > 4 && "FORCE".equalsIgnoreCase((String)vector.get(4))) {
                                bl = true;
                            }
                            vSerialHelper.authenticate(l, n, s9);
                            byte[] byArray = SLICSerialCommandMessage.createActivateConsoleRequest(vSerialHelper.getCurrCorrelationToken(), bl).getBytes();
                            object = new byte[byArray.length * 2 + 2];
                            int n2 = IPSlipUtil.slipEncode(byArray, 0, byArray.length, (byte[])object, 0);
                            hardwareServerMessage = HardwareServerMessage.buildVserialWrite(n, vSerialHelper.getCurrCorrelationToken(), s9, s10, (byte[])object, n2);
                            vSerialHelper.sendMessage(hardwareServerMessage);
                        }
                        catch (IOException iOException) {
                            VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65533L, iOException.toString());
                        }
                        catch (SecurityException securityException) {
                            VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65532L, securityException.toString());
                        }
                        catch (Exception exception) {
                            VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65535L, exception.toString());
                        }
                        continue;
                    }
                    VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65534L, "invalid parms use the 'help' command");
                    continue;
                }
                if (s_slicEchoCommand.equals(string3)) {
                    VSerialHelper.logTrace("read: " + string2);
                    if (vector.size() >= 4) {
                        long l = 0L;
                        try {
                            l = Long.parseLong((String)vector.get(1), 16);
                            int n = Integer.parseInt((String)vector.get(2));
                            short s11 = Short.parseShort((String)vector.get(3));
                            String string8 = (String)vector.get(4);
                            byte[] byArray = string8.getBytes();
                            vSerialHelper.authenticate(l, n, s11);
                            vSerialHelper.sendSlicEcho(n, s11, (short)1, vSerialHelper.getCurrCorrelationToken(), byArray);
                        }
                        catch (IOException iOException) {
                            VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65533L, iOException.toString());
                        }
                        catch (SecurityException securityException) {
                            VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65532L, securityException.toString());
                        }
                        catch (Exception exception) {
                            VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65535L, exception.toString());
                        }
                        continue;
                    }
                    VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65534L, "invalid parms use the 'help' command");
                    continue;
                }
                if (s_slicSurveillanceCommand.equals(string3)) {
                    VSerialHelper.logTrace("read: " + string2);
                    if (vector.size() < 4) continue;
                    try {
                        long l = Long.parseLong((String)vector.get(1), 16);
                        int n = Integer.parseInt((String)vector.get(2));
                        short s12 = Short.parseShort((String)vector.get(3));
                        short s13 = 1;
                        if (vector.size() >= 5) {
                            s13 = Short.parseShort((String)vector.get(4));
                        }
                        vSerialHelper.authenticate(l, n, s12);
                        vSerialHelper.startSurveillance(n, s12, s13);
                        VSerialHelper.logTrace("starting surveillance");
                        VSerialHelper.logResponseMsg(vSerialHelper.getCurrCorrelationToken(), "");
                    }
                    catch (Exception exception) {
                        VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65535L, exception.toString());
                        exception.printStackTrace();
                    }
                    continue;
                }
                if (s_sendSlicCommand.equals(string3)) {
                    VSerialHelper.logTrace("read: " + string2);
                    if (vector.size() == 5 || vector.size() == 6) {
                        try {
                            int n = Integer.parseInt((String)vector.get(1));
                            s = Short.parseShort((String)vector.get(2));
                            short s14 = Short.parseShort((String)vector.get(3));
                            int n3 = Integer.parseInt((String)vector.get(4));
                            String string9 = "";
                            if (vector.size() == 6) {
                                string9 = (String)vector.get(5);
                            }
                            byte[] byArray = string9.getBytes();
                            byte[] byArray3 = SLICSerialCommandMessage.createRawEchoRequest(5, byArray).getBytes();
                            object = new byte[byArray3.length * 2 + 2];
                            int n4 = IPSlipUtil.slipEncode(byArray3, 0, byArray3.length, (byte[])object, 0);
                            hardwareServerMessage = HardwareServerMessage.buildVserialWrite(n, vSerialHelper.getCurrCorrelationToken(), s, s14, (byte[])object, n4);
                            vSerialHelper.sendMessage(hardwareServerMessage);
                        }
                        catch (IOException iOException) {
                            VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65533L, iOException.toString());
                        }
                        catch (SecurityException securityException) {
                            VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65532L, securityException.toString());
                        }
                        catch (Exception exception) {
                            VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65535L, exception.toString());
                        }
                        continue;
                    }
                    VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65534L, "invalid parms use the 'help' command");
                    continue;
                }
                if (s_setTraceLevelCommand.equals(string3)) {
                    VSerialHelper.logTrace("read: " + string2);
                    try {
                        int n = Integer.parseInt((String)vector.get(1), 16);
                        VSerialHelper.setTraceLevel(n);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (s_dumpStateCommand.equals(string3)) {
                    VSerialHelper.logTrace("read: " + string2);
                    if (vector.size() < 4) continue;
                    try {
                        long l = Long.parseLong((String)vector.get(1), 16);
                        int n = Integer.parseInt((String)vector.get(2));
                        short s15 = Short.parseShort((String)vector.get(3));
                        short s16 = 1;
                        if (vector.size() >= 5) {
                            s16 = Short.parseShort((String)vector.get(4));
                        }
                        int n5 = vSerialHelper.getCurrCorrelationToken();
                        vSerialHelper.authenticate(l, n, s15);
                        vSerialHelper.sendGetInterfaceInfo(n, s15, s16, n5);
                        vSerialHelper.sendDumpVIOSLIPFR(n, s15, s16, vSerialHelper.getNextCorrelationToken());
                        vSerialHelper.sendGetConsoleInfo(n, s15, s16, vSerialHelper.getNextCorrelationToken());
                        vSerialHelper.sendGetConnectionStats(n, s15, s16, vSerialHelper.getNextCorrelationToken());
                        VSerialHelper.logResponseMsg(n5, "");
                    }
                    catch (Exception exception) {
                        VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65535L, exception.toString());
                        exception.printStackTrace();
                    }
                    continue;
                }
                if (s_getHelpCommand.equals(string3)) {
                    outputPrintStream.println("help for vserialhelper:");
                    outputPrintStream.println("  'help' - displays this help");
                    outputPrintStream.println("  'exit' - exits the program");
                    outputPrintStream.println("  'auth userid password' - log in");
                    outputPrintStream.println("  'logout authtok' - log out");
                    outputPrintStream.println("  'sysinfo authtok' - get system info");
                    outputPrintStream.println("  'ptninfo authtok vport' - get partition info");
                    outputPrintStream.println("  'open-serial authtok vport partitionId [sessionId] protocol[RAW|SLIP]'");
                    outputPrintStream.println("  'close-serial authtok vport partitionId [sessionId] [FORCE]'");
                    outputPrintStream.println("  'list-serial authtok vport'");
                    outputPrintStream.println("  'init-cond authtok vport partitionId [FORCE]'");
                    outputPrintStream.println("  'slic-echo authtok vport partitionid echoString'");
                    outputPrintStream.println("  'slic-surveillance authtok vport partitionid [sessionId]'");
                    outputPrintStream.println("  'writetext authtok vport partitionId sessionId ttyWord'");
                    outputPrintStream.println("  'trace newloglevel' (hex) - F=all 0=none");
                    outputPrintStream.println("  'dump-state authtok vport partitionid [sessionId]'");
                    continue;
                }
                if (s_exitCommand.equals(string3)) {
                    VSerialHelper.logTrace("Exiting");
                    System.exit(0);
                    continue;
                }
                VSerialHelper.logError(vSerialHelper.getCurrCorrelationToken(), 65534L, "invalid parms use the 'help' command");
            }
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception);
            exception.printStackTrace(System.err);
            System.exit(1);
            return;
        }
    }

    public long getUPToken(String string, String string2) throws SecurityException {
        Long l;
        long l2;
        UPMapEntry uPMapEntry = new UPMapEntry(string, string2);
        VSerialInfoClient.newInstance(this, uPMapEntry);
        Random random = new Random();
        do {
            l2 = random.nextInt() & Integer.MAX_VALUE;
            l = new Long(l2);
        } while (l2 == 0L || this.m_upMap.containsKey(l));
        this.m_upMap.put(l, uPMapEntry);
        return l2;
    }

    private Object getUP(long l) throws SecurityException {
        Object v = this.m_upMap.get(new Long(l));
        if (v == null) {
            throw new SecurityException("Not authorized");
        }
        return v;
    }

    String getHSIPAddr() {
        return this.m_hdwrSvrIpAddress;
    }

    public VSerialHelper(String string, boolean bl) throws IOException {
        this.m_sessionMap = new Hashtable();
        this.m_correlationTokenMap = new Hashtable();
        this.m_upMap = new HashMap();
        this.m_hdwrSvrIpAddress = string;
        this.m_hdwr_svrSocket = new Socket(this.m_hdwrSvrIpAddress, 8877);
        this.m_socketInput = new DataInputStream(this.m_hdwr_svrSocket.getInputStream());
        this.m_socketOutput = new DataOutputStream(this.m_hdwr_svrSocket.getOutputStream());
        this.startSocketListener();
    }

    public VSerialSystemInfo[] getSystemInformation(long l) throws SecurityException {
        UPMapEntry uPMapEntry = (UPMapEntry)this.getUP(l);
        return uPMapEntry.getClient().getSystemInformation();
    }

    public void authenticate(long l, int n, int n2) throws SecurityException {
        Object v = this.m_upMap.get(new Long(l));
        if (v == null) {
            throw new SecurityException("authentication failed");
        }
    }

    public void sendSlicEcho(int n, short s, short s2, int n2, byte[] byArray) throws IOException {
        byte[] byArray2 = SLICSerialCommandMessage.createRawEchoRequest(n2, byArray).getBytes();
        byte[] byArray3 = new byte[byArray2.length * 2 + 2];
        int n3 = IPSlipUtil.slipEncode(byArray2, 0, byArray2.length, byArray3, 0);
        HardwareServerMessage hardwareServerMessage = HardwareServerMessage.buildVserialWrite(n, n2, s, s2, byArray3, n3);
        this.sendMessage(hardwareServerMessage, false);
    }

    public void sendGetInterfaceInfo(int n, short s, short s2, int n2) throws IOException {
        byte[] byArray = SLICSerialCommandMessage.createGetInterfaceVersionRequest(n2).getBytes();
        byte[] byArray2 = new byte[byArray.length * 2 + 2];
        int n3 = IPSlipUtil.slipEncode(byArray, 0, byArray.length, byArray2, 0);
        HardwareServerMessage hardwareServerMessage = HardwareServerMessage.buildVserialWrite(n, n2, s, s2, byArray2, n3);
        this.sendMessage(hardwareServerMessage);
    }

    public void sendGetConnectionStats(int n, short s, short s2, int n2) throws IOException {
        byte[] byArray = SLICSerialCommandMessage.createConnectionStatRequest(n2).getBytes();
        byte[] byArray2 = new byte[byArray.length * 2 + 2];
        int n3 = IPSlipUtil.slipEncode(byArray, 0, byArray.length, byArray2, 0);
        HardwareServerMessage hardwareServerMessage = HardwareServerMessage.buildVserialWrite(n, n2, s, s2, byArray2, n3);
        this.sendMessage(hardwareServerMessage);
    }

    public void sendGetConsoleInfo(int n, short s, short s2, int n2) throws IOException {
        byte[] byArray = SLICSerialCommandMessage.createDSTInfoRequest(n2).getBytes();
        byte[] byArray2 = new byte[byArray.length * 2 + 2];
        int n3 = IPSlipUtil.slipEncode(byArray, 0, byArray.length, byArray2, 0);
        HardwareServerMessage hardwareServerMessage = HardwareServerMessage.buildVserialWrite(n, n2, s, s2, byArray2, n3);
        this.sendMessage(hardwareServerMessage);
    }

    public void sendDumpVIOSLIPFR(int n, short s, short s2, int n2) throws IOException {
        byte[] byArray = SLICSerialCommandMessage.createDumpVIOSLIPFRRequest(n2, 0L).getBytes();
        byte[] byArray2 = new byte[byArray.length * 2 + 2];
        int n3 = IPSlipUtil.slipEncode(byArray, 0, byArray.length, byArray2, 0);
        HardwareServerMessage hardwareServerMessage = HardwareServerMessage.buildVserialWrite(n, n2, s, s2, byArray2, n3);
        this.sendMessage(hardwareServerMessage);
    }

    private void sendGetPartitionInformation(long l, String string) throws SecurityException, IOException, Exception {
        UPMapEntry uPMapEntry = (UPMapEntry)this.getUP(l);
        if (uPMapEntry == null) {
            throw new SecurityException("authentication failed");
        }
        HardwareServerUtilities hardwareServerUtilities = new HardwareServerUtilities(this.m_hdwrSvrIpAddress);
        VSerialSystemInfo vSerialSystemInfo = hardwareServerUtilities.getSystemInfoFromKey(string);
        if (vSerialSystemInfo == null) {
            throw new Exception("invalid system identifier: " + string);
        }
        HardwareServerMessage hardwareServerMessage = HardwareServerUtilities.buildFspRequestMsg(vSerialSystemInfo.m_hardware_server_vport, 32769, 513, this.getCurrCorrelationToken(), null);
        this.sendMessage(hardwareServerMessage);
    }

    public VSerialPartitionInfo[] getPartitionInformation(long l, String string) throws SecurityException {
        UPMapEntry uPMapEntry = (UPMapEntry)this.getUP(l);
        if (uPMapEntry == null) {
            throw new SecurityException("authentication failed");
        }
        return uPMapEntry.getClient().getPartitionInformation(string);
    }

    public void open(int n, short s, short s2, short s3, VSerialSessionIfc vSerialSessionIfc) {
        Long l = VSerialHelper.generateKey(n, s, s2);
        this.m_sessionMap.put(l, vSerialSessionIfc);
        int n2 = this.getNextCorrelationToken();
        try {
            if (vSerialSessionIfc != null) {
                vSerialSessionIfc.sessionStateChanged(2, null);
            }
            HardwareServerMessage hardwareServerMessage = HardwareServerMessage.buildVserialOpenRequest(n, n2, s, s2, (short)0, s3);
            this.m_correlationTokenMap.put(new Integer(n2), new CorrelationTokenMapEntry(vSerialSessionIfc, hardwareServerMessage));
            this.sendMessage(hardwareServerMessage);
        }
        catch (IOException iOException) {
            if (vSerialSessionIfc != null) {
                vSerialSessionIfc.sessionStateChanged(4, null);
            }
            VSerialHelper.logError(n2, 65533L, "unable to send message to hws");
        }
    }

    public void close(int n, short s, short s2, boolean bl) {
        Long l = VSerialHelper.generateKey(n, s, s2);
        VSerialSessionIfc vSerialSessionIfc = (VSerialSessionIfc)this.m_sessionMap.get(l);
        int n2 = this.getNextCorrelationToken();
        try {
            HardwareServerMessage hardwareServerMessage = HardwareServerMessage.buildVserialCloseRequest(n, n2, s, s2, bl);
            this.m_correlationTokenMap.put(new Integer(n2), new CorrelationTokenMapEntry(vSerialSessionIfc, hardwareServerMessage));
            this.sendMessage(hardwareServerMessage);
            if (vSerialSessionIfc != null) {
                vSerialSessionIfc.sessionStateChanged(5, null);
            }
        }
        catch (IOException iOException) {
            if (vSerialSessionIfc != null) {
                vSerialSessionIfc.sessionStateChanged(4, null);
            }
            VSerialHelper.logError(n2, 65533L, "unable to send close message to hws");
        }
    }

    public void closeAndWait(int n, short s, short s2, boolean bl) throws InterruptedException {
        Long l = VSerialHelper.generateKey(n, s, s2);
        VSerialSessionIfc vSerialSessionIfc = (VSerialSessionIfc)this.m_sessionMap.get(l);
        int n2 = this.getNextCorrelationToken();
        try {
            HardwareServerMessage hardwareServerMessage = HardwareServerMessage.buildVserialCloseRequest(n, n2, s, s2, bl);
            Integer n3 = new Integer(n2);
            this.m_correlationTokenMap.put(n3, new CorrelationTokenMapEntry(vSerialSessionIfc, hardwareServerMessage));
            this.sendMessage(hardwareServerMessage);
            if (vSerialSessionIfc != null) {
                vSerialSessionIfc.sessionStateChanged(5, null);
            }
            for (int i = 0; i < 12 && this.m_correlationTokenMap.get(n3) != null; ++i) {
                Thread.sleep(5000L);
            }
        }
        catch (IOException iOException) {
            if (vSerialSessionIfc != null) {
                vSerialSessionIfc.sessionStateChanged(4, null);
            }
            VSerialHelper.logError(n2, 65533L, "unable to send close message to hws");
        }
    }

    public void write(int n, short s, short s2, byte[] byArray, int n2) {
        Long l = VSerialHelper.generateKey(n, s, s2);
        VSerialSessionIfc vSerialSessionIfc = (VSerialSessionIfc)this.m_sessionMap.get(l);
        int n3 = 0;
        try {
            HardwareServerMessage hardwareServerMessage = HardwareServerMessage.buildVserialWrite(n, n3, s, s2, byArray, n2);
            this.m_correlationTokenMap.put(new Integer(n3), new CorrelationTokenMapEntry(vSerialSessionIfc, hardwareServerMessage));
            this.sendMessage(hardwareServerMessage);
        }
        catch (IOException iOException) {
            if (vSerialSessionIfc != null) {
                vSerialSessionIfc.sessionStateChanged(4, null);
            }
            VSerialHelper.logError(n3, 65533L, "unable to send message to hws");
        }
    }

    public void stopSocketListener() {
        this.m_needToStopSockListener = true;
    }

    private void startSocketListener() {
        Runnable runnable = new Runnable(){

            public void run() {
                boolean bl = false;
                while (!VSerialHelper.this.m_needToStopSockListener) {
                    try {
                        HardwareServerMessage hardwareServerMessage = new HardwareServerMessage(VSerialHelper.this.m_socketInput);
                        VSerialHelper.this.parseIncoming(hardwareServerMessage);
                        bl = false;
                    }
                    catch (IOException iOException) {
                        VSerialHelper.logError(0xFFFFFFL, 65533L, "caught an io exception while reading from hws:\n  " + iOException);
                        if (VSerialHelper.this.m_needToStopSockListener) continue;
                        System.exit(1);
                    }
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    private void sendMessage(HardwareServerMessage hardwareServerMessage) throws IOException {
        this.sendMessage(hardwareServerMessage, true);
    }

    private void sendMessage(HardwareServerMessage hardwareServerMessage, boolean bl) throws IOException {
        if (bl) {
            VSerialHelper.logComm("Sending message:" + hardwareServerMessage);
        }
        outputPrintStream.flush();
        this.m_socketOutput.write(hardwareServerMessage.toBytes());
    }

    private void parseIncoming(HardwareServerMessage hardwareServerMessage) throws IOException {
        block62: {
            try {
                System.out.println("In parseIncoming: op code = " + hardwareServerMessage.getMinorOpCode());
                byte[] byArray = hardwareServerMessage.getPayload();
                int n = hardwareServerMessage.getCorrelator() & 0xFFFF;
                int n2 = hardwareServerMessage.getVport();
                CorrelationTokenMapEntry correlationTokenMapEntry = (CorrelationTokenMapEntry)this.m_correlationTokenMap.get(new Integer(n));
                if (hardwareServerMessage.getMajorOpCode() != 144 || hardwareServerMessage.getMinorOpCode() != 13) {
                    this.m_correlationTokenMap.remove(new Integer(n));
                    System.out.println("parseIncoming : NOT an inbound, remove correlator");
                }
                VSerialSessionIfc vSerialSessionIfc = null;
                HardwareServerMessage hardwareServerMessage2 = null;
                if (correlationTokenMapEntry != null) {
                    vSerialSessionIfc = correlationTokenMapEntry.session;
                    hardwareServerMessage2 = correlationTokenMapEntry.message;
                } else {
                    System.out.println("parseIncoming : entry object IS null");
                }
                if (hardwareServerMessage.getMajorOpCode() == 144) {
                    switch (hardwareServerMessage.getMinorOpCode()) {
                        case 1: 
                        case 4: 
                        case 7: 
                        case 10: 
                        case 96: {
                            VSerialHelper.logComm("incoming msg" + hardwareServerMessage);
                            VSerialHelper.logError(0xFFFFFFL, 65535L, "unexpected response: got a request from hws");
                            if (vSerialSessionIfc != null) {
                                vSerialSessionIfc.sessionStateChanged(4, null);
                            }
                            throw new IOException("Hardware server protocol violation");
                        }
                        case 3: 
                        case 6: 
                        case 9: 
                        case 12: 
                        case 98: {
                            int[] nArray = new int[2];
                            System.out.println("op code = " + hardwareServerMessage.getMinorOpCode());
                            System.out.print("payload = ");
                            for (int i = 0; i < byArray.length; ++i) {
                                System.out.print(Integer.toHexString(byArray[i]) + " ");
                            }
                            System.out.println();
                            System.out.println("Got Vserial open failure error = " + hardwareServerMessage.getErrorCode() + " on vport " + hardwareServerMessage.getVport());
                            if (byArray.length >= 4) {
                                VSerialHelper.logError(n, HardwareServerMessage.bytesToUInt(byArray, 0), "got a vserial failure response from hardware server");
                            } else {
                                VSerialHelper.logError(n, 65535L, "got an unrecognized vserial error response from hardware server");
                            }
                            switch (hardwareServerMessage.getMinorOpCode()) {
                                case 3: {
                                    if (vSerialSessionIfc != null) {
                                        nArray[0] = 3;
                                    }
                                    System.out.println("HardwareServerMessage.HS_MIN_VSERIAL_LIST_FAILURE");
                                    break;
                                }
                                case 6: {
                                    if (vSerialSessionIfc != null) {
                                        nArray[0] = 6;
                                    }
                                    System.out.println("HardwareServerMessage.HS_MIN_VSERIAL_OPEN_FAILURE");
                                    break;
                                }
                                case 9: {
                                    if (vSerialSessionIfc != null) {
                                        nArray[0] = 9;
                                    }
                                    System.out.println("HardwareServerMessage.HS_MIN_VSERIAL_CLOSE_FAILURE");
                                    break;
                                }
                                case 12: {
                                    if (vSerialSessionIfc != null) {
                                        nArray[0] = 12;
                                    }
                                    System.out.println("HardwareServerMessage.HS_MIN_VSERIAL_WRITE_FAILURE");
                                    break;
                                }
                                case 98: {
                                    if (vSerialSessionIfc != null) {
                                        nArray[0] = 98;
                                    }
                                    System.out.println("HardwareServerMessage.HS_MIN_FSP_ERR");
                                    break;
                                }
                                default: {
                                    System.out.println("Should not get here");
                                }
                            }
                            if (vSerialSessionIfc != null) {
                                nArray[1] = 0;
                                vSerialSessionIfc.sessionStateChanged(4, nArray);
                            } else {
                                System.out.println("VSerial: ERROR requestSession is NULL");
                            }
                            break block62;
                        }
                        case 2: {
                            int n3;
                            int n4;
                            VSerialHelper.logComm("incoming msg" + hardwareServerMessage);
                            VSerialHelper.logTrace("Incoming msg correlator = 0x" + Long.toHexString(n));
                            VSerialHelper.logTrace("got a list response");
                            if (byArray.length >= 4) {
                                n4 = HardwareServerMessage.bytesToUShort(byArray, 0);
                                n3 = byArray[2];
                                VSerialHelper.logTrace(" percec,perptn = " + n4 + ", " + n3);
                            }
                            if (byArray.length == 4) {
                                VSerialHelper.logError(n, 0L, "no data to return");
                            } else {
                                VSerialHelper.logResponseHeader(n);
                                for (n4 = 4; n4 < byArray.length; n4 += 8) {
                                    n3 = HardwareServerMessage.bytesToUShort(byArray, n4);
                                    int n5 = HardwareServerMessage.bytesToUShort(byArray, n4 + 2);
                                    asyncPrintStream.println("\"" + n3 + "\",\"" + n5 + "\",\"" + HardwareServerMessage.bytesToIPv4String(byArray, n4 + 4) + "\"");
                                }
                                VSerialHelper.logResponseTrailer();
                            }
                            break block62;
                        }
                        case 5: {
                            VSerialHelper.logComm(n2 + " incoming msg" + hardwareServerMessage);
                            VSerialHelper.logTrace(n2 + " Incoming msg correlator = 0x" + Long.toHexString(n));
                            VSerialHelper.logTrace(n2 + " Incoming msg correlator = " + n);
                            VSerialHelper.logTrace(n2 + " 00 - got an open response");
                            String string = "";
                            if (byArray.length >= 4) {
                                string = "\"" + HardwareServerMessage.bytesToIPv4String(byArray, 0) + "\"";
                            }
                            VSerialHelper.logResponseMsg(n, string);
                            if (vSerialSessionIfc != null) {
                                vSerialSessionIfc.sessionStateChanged(3, null);
                            }
                            break block62;
                        }
                        case 8: {
                            VSerialHelper.logComm(n2 + " incoming msg" + hardwareServerMessage);
                            VSerialHelper.logTrace(n2 + " Incoming msg correlator = 0x" + Long.toHexString(n));
                            VSerialHelper.logTrace(n2 + " 00 - got a close response");
                            VSerialHelper.logResponseMsg(n, "");
                            if (vSerialSessionIfc != null) {
                                vSerialSessionIfc.sessionStateChanged(1, null);
                            }
                            break block62;
                        }
                        case 11: {
                            VSerialHelper.logComm(n2 + " incoming msg" + hardwareServerMessage);
                            VSerialHelper.logTrace(n2 + " Incoming msg correlator = 0x" + Long.toHexString(n));
                            VSerialHelper.logTrace(n2 + " 00 - got a write response");
                            VSerialHelper.logResponseMsg(n, "");
                            break block62;
                        }
                        case 13: {
                            VSerialHelper.logTrace("got inbound vtty data");
                            if (byArray.length >= 6) {
                                int n6 = HardwareServerMessage.bytesToUShort(byArray, 0);
                                int n7 = HardwareServerMessage.bytesToUShort(byArray, 2);
                                int n8 = HardwareServerMessage.bytesToUShort(byArray, 4);
                                Long l = VSerialHelper.generateKey(n2, n6, n7);
                                VSerialSessionIfc vSerialSessionIfc2 = (VSerialSessionIfc)this.m_sessionMap.get(l);
                                if (vSerialSessionIfc2 != null) {
                                    vSerialSessionIfc2.incomingData(byArray, 6, n8);
                                } else {
                                    this.processIncomingSLIPData(byArray, 6, n8, l);
                                }
                                VSerialHelper.logTrace("Inbound data vp,pid,sid,len = 0x" + Integer.toHexString(n2) + ",0d" + n6 + ",0d" + n7 + ",0d" + n8);
                            }
                            break block62;
                        }
                        default: {
                            VSerialHelper.logComm(n2 + " incoming msg" + hardwareServerMessage);
                            VSerialHelper.logTrace(n2 + " Incoming msg correlator = 0x" + Long.toHexString(n));
                            VSerialHelper.logError((long)n2 + 0xFFFFFFL, 65533L, " unrecognized vserial minor opcode: " + hardwareServerMessage.getMinorOpCode());
                            throw new IOException("hws protocol violation: minor opcode" + hardwareServerMessage.getMinorOpCode());
                        }
                    }
                }
                if (hardwareServerMessage.getMajorOpCode() == 80) {
                    VSerialHelper.logComm("incoming msg" + hardwareServerMessage);
                    HardwareServerUtilities.FspMessageLight fspMessageLight = HardwareServerUtilities.getFspPassthroughResponseErrorCode(hardwareServerMessage);
                    if (fspMessageLight.parsingerror == 0L) {
                        int n9;
                        byte[] byArray2 = fspMessageLight.payload;
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
                        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                        int n10 = dataInputStream.readShort() & 0xFFFF;
                        Vector<VSerialPartitionInfo> vector = new Vector<VSerialPartitionInfo>();
                        for (n9 = 0; n9 < n10; ++n9) {
                            int n11 = dataInputStream.readByte() & 0xFF;
                            if (n11 <= 128 || n11 >= 144) continue;
                            vector.add(new VSerialPartitionInfo(n9 + 1, n11 == 130 ? 2 : 0, n11 == 130 ? "UNKNOWN " : "DISABLED", VSerialPartitionInfo.CONSOLE_STATE_UNKNOWN, "", "", ""));
                        }
                        if (vector == null || vector.size() == 0) {
                            VSerialHelper.logError(n, 0L, "no data to return");
                        } else {
                            VSerialHelper.logResponseHeader(n);
                            for (n9 = 0; n9 < vector.size(); ++n9) {
                                asyncPrintStream.println(((VSerialPartitionInfo)vector.get(n9)).toVSerialString("A"));
                            }
                            VSerialHelper.logResponseTrailer();
                        }
                    } else {
                        VSerialHelper.logError(n, 0L, "got an fsp passthrough failure response from hardware server");
                    }
                } else if (hardwareServerMessage.getMajorOpCode() == 160) {
                    VSerialHelper.logComm("incoming msg" + hardwareServerMessage);
                    block17 : switch (hardwareServerMessage.getMinorOpCode()) {
                        case 124: {
                            int n12 = hardwareServerMessage.getVirtualPort();
                            int n13 = HardwareServerMessage.bytesToUShort(hardwareServerMessage.getPayload(), 0);
                            int n14 = HardwareServerMessage.bytesToUShort(hardwareServerMessage.getPayload(), 2);
                            int n15 = HardwareServerMessage.bytesToUShort(hardwareServerMessage.getPayload(), 4);
                            VSerialHelper.logTrace("VSerial state change async: vport = " + n12 + ", partition = " + n13 + ", session = " + n14 + ", state = " + n15);
                            switch (n15) {
                                case 0: {
                                    VSerialHelper.logTrace("State = DOWN");
                                    Long l = VSerialHelper.generateKey(n12, n13, n14);
                                    VSerialHelper.logError(0xFFFFFFL, 65531L, Long.toHexString(l) + " VSerial session down");
                                    break block17;
                                }
                                case 1: {
                                    VSerialHelper.logTrace("State = XOFF");
                                    break block17;
                                }
                                case 2: {
                                    VSerialHelper.logTrace("State = UP");
                                    break block17;
                                }
                            }
                            VSerialHelper.logTrace("Unrecognized state change");
                            break;
                        }
                        default: {
                            VSerialHelper.logTrace("unrecognized async minor opcode: " + hardwareServerMessage.getMinorOpCode());
                            break;
                        }
                    }
                } else {
                    VSerialHelper.logComm("incoming msg" + hardwareServerMessage);
                    VSerialHelper.logError(0xFFFFFFL, 65533L, "unrecognized major opcode - " + hardwareServerMessage.getMajorOpCode());
                }
            }
            catch (IOException iOException) {
                VSerialHelper.logError(0xFFFFFFL, 65533L, iOException.toString());
                iOException.printStackTrace();
                throw iOException;
            }
            catch (Exception exception) {
                VSerialHelper.logError(0xFFFFFFL, 65533L, exception.toString());
                exception.printStackTrace();
            }
        }
    }

    void processIncomingSLIPData(byte[] byArray, int n, int n2, Long l) {
        if (n2 < 3) {
            return;
        }
        try {
            if (byArray[n] == -64 && byArray[n + 1] == -1) {
                byte[] byArray2 = new byte[n2];
                int n3 = IPSlipUtil.slipDecode(byArray, n + 1, n2 - 1, byArray2, 0);
                SLICSerialCommandMessage sLICSerialCommandMessage = new SLICSerialCommandMessage(byArray2, 0, n3);
                if (sLICSerialCommandMessage.getOpcode() == 2 && (long)sLICSerialCommandMessage.getCorrelationToken() == 65535L) {
                    this.setSurveillanceDate(l, null);
                    return;
                }
                int n4 = sLICSerialCommandMessage.getReturnCode();
                VSerialHelper.logTrace("Inbound slic serial cmd ct, op, rc = " + sLICSerialCommandMessage.getCorrelationToken() + ", " + sLICSerialCommandMessage.getOpcode() + ", " + n4);
                switch (sLICSerialCommandMessage.getOpcode()) {
                    case 4: {
                        VSerialHelper.logError(0xFFFFFFL, 65531L, Long.toHexString(l) + " Connection reset");
                        return;
                    }
                }
                if (n4 == 0) {
                    switch (sLICSerialCommandMessage.getOpcode()) {
                        case 1: {
                            VSerialHelper.logTrace("Received Interface info response");
                            this.dumpInterfaceInfo(this.getDumpStateOutputFilename(l), sLICSerialCommandMessage.getParmBytes());
                            break;
                        }
                        case 3: {
                            VSerialHelper.logTrace("Received Command stats response");
                            this.dumpCommandStats(this.getDumpStateOutputFilename(l), sLICSerialCommandMessage.getParmBytes());
                            break;
                        }
                        case 5: {
                            VSerialHelper.logTrace("Received DST Console Info response");
                            this.dumpConsoleInfo(this.getDumpStateOutputFilename(l), sLICSerialCommandMessage.getParmBytes());
                            break;
                        }
                        case 11: {
                            VSerialHelper.logTrace("Received VIOSLIPFR response");
                            this.dumpVIOSLIPFR(this.getDumpStateOutputFilename(l), sLICSerialCommandMessage.getParmBytes());
                            break;
                        }
                        default: {
                            long l2 = sLICSerialCommandMessage.getCorrelationToken() & 0xFFFF;
                            if (l2 == 65535L) {
                                l2 = 0xFFFFFFL;
                            }
                            VSerialHelper.logResponseMsg(l2, "");
                            break;
                        }
                    }
                } else {
                    long l3;
                    if (n4 == 258) {
                        byte[] byArray3 = sLICSerialCommandMessage.getParmBytes();
                        l3 = ByteUtilities.byteArrayToLong(byArray3, 0);
                    } else {
                        l3 = n4;
                    }
                    switch (sLICSerialCommandMessage.getOpcode()) {
                        case 1: {
                            VSerialHelper.logTrace("Received Interface info error response: " + l3);
                            break;
                        }
                        case 3: {
                            VSerialHelper.logTrace("Received Command stats error response: " + l3);
                            break;
                        }
                        case 5: {
                            VSerialHelper.logTrace("Received DST Console Info error response: " + l3);
                            break;
                        }
                        case 11: {
                            VSerialHelper.logTrace("Received VIOSLIPFR response error response: " + l3);
                            break;
                        }
                        default: {
                            VSerialHelper.logError(sLICSerialCommandMessage.getCorrelationToken(), l3, "");
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            System.err.println("processIncomingSLIPData exception: " + throwable.toString());
            throwable.printStackTrace();
        }
    }

    private String getDumpStateOutputFilename(Long l) {
        StringBuffer stringBuffer = new StringBuffer("/var/hsc/log/hmc5250_");
        long l2 = l;
        int n = (int)(l2 >> 32);
        int n2 = (int)(l2 >> 16 & 0xFFFFL);
        stringBuffer.append(n2).append("*");
        int n3 = (int)(l2 & 0xFFFFL);
        try {
            VSerialSystemInfo vSerialSystemInfo = this.m_hdwr_svrUtil.getSystemInfoFromKey(n + "");
            if (vSerialSystemInfo != null) {
                stringBuffer.append(vSerialSystemInfo.m_type_model_serial);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return stringBuffer.toString();
    }

    private void dumpInterfaceInfo(String string, byte[] byArray) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string, true);
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(fileOutputStream)));
            printWriter.println("******************************************");
            printWriter.println("Interface info: " + new Date().toString());
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            int n = dataInputStream.readUnsignedShort();
            printWriter.println("Interface Version = " + ByteUtilities.toHexString(new Long(n), 4));
            n = dataInputStream.readUnsignedShort();
            printWriter.println("SLIP MTU = " + ByteUtilities.toHexString(new Long(n), 4));
            n = dataInputStream.readUnsignedShort();
            printWriter.println("Command MTU = " + ByteUtilities.toHexString(new Long(n), 4));
            n = dataInputStream.readUnsignedShort();
            printWriter.println("Capability Length = " + ByteUtilities.toHexString(new Long(n), 4));
            int n2 = dataInputStream.readUnsignedByte();
            printWriter.println("Cap0 = " + ByteUtilities.toHexString(new Long(n2), 2));
            n2 = dataInputStream.readUnsignedByte();
            printWriter.println("Cap1 = " + ByteUtilities.toHexString(new Long(n2), 2));
            n2 = dataInputStream.readUnsignedByte();
            printWriter.println("Cap2 = " + ByteUtilities.toHexString(new Long(n2), 2));
            n2 = dataInputStream.readUnsignedByte();
            printWriter.println("Cap3 = " + ByteUtilities.toHexString(new Long(n2), 2));
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void dumpVIOSLIPFR(String string, byte[] byArray) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string, true);
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(fileOutputStream)));
            printWriter.println("******************************************");
            printWriter.println("VIOSLIPFR: " + new Date().toString());
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            long l = dataInputStream.readLong();
            printWriter.println("Total number of entries: " + l);
            l = byArray.length / 8 - 1;
            printWriter.println("Actual number of entries: " + l);
            for (long i = 0L; i < l; ++i) {
                long l2 = dataInputStream.readLong();
                printWriter.println(ByteUtilities.toHexString(new Long(l2), 16));
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void dumpConsoleInfo(String string, byte[] byArray) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string, true);
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(fileOutputStream)));
            printWriter.println("******************************************");
            printWriter.println("Console info: " + new Date().toString());
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            int n = dataInputStream.readUnsignedShort();
            int n2 = dataInputStream.readInt();
            printWriter.println("Console IOP DSA = " + ByteUtilities.toHexString(new Long(n << 32 | n2), 12));
            n = dataInputStream.readUnsignedShort();
            printWriter.println("Reserved0 = " + ByteUtilities.toHexString(new Long(n), 4));
            n = dataInputStream.readUnsignedShort();
            n2 = dataInputStream.readInt();
            printWriter.println("Console IOA DSA = " + ByteUtilities.toHexString(new Long(n << 32 | n2), 12));
            n = dataInputStream.readUnsignedShort();
            printWriter.println("Virtual Console Slot = " + ByteUtilities.toHexString(new Long(n), 4));
            int n3 = dataInputStream.readUnsignedByte();
            printWriter.println("Current Console Type = " + ByteUtilities.toHexString(new Long(n3), 2));
            n3 = dataInputStream.readUnsignedByte();
            printWriter.println("Reserved1 = " + ByteUtilities.toHexString(new Long(n3), 2));
            n3 = dataInputStream.readUnsignedByte();
            printWriter.println("Remote DST Active = " + ByteUtilities.toHexString(new Long(n3), 2));
            n3 = dataInputStream.readUnsignedByte();
            printWriter.println("DST Connect Type = " + ByteUtilities.toHexString(new Long(n3), 2));
            n3 = dataInputStream.readUnsignedByte();
            printWriter.println("Bootp Daemon Busy = " + ByteUtilities.toHexString(new Long(n3), 2));
            n3 = dataInputStream.readUnsignedByte();
            printWriter.println("Share Console Type = " + ByteUtilities.toHexString(new Long(n3), 2));
            n = dataInputStream.readUnsignedShort();
            printWriter.println("Reserved2 = " + ByteUtilities.toHexString(new Long(n), 4));
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void dumpCommandStats(String string, byte[] byArray) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string, true);
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(fileOutputStream)));
            printWriter.println("******************************************");
            printWriter.println("Command stats: " + new Date().toString());
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            int n = dataInputStream.readInt();
            printWriter.println("Bytes Rx = " + ByteUtilities.toHexString(new Long(n), 8));
            n = dataInputStream.readInt();
            printWriter.println("Bytes Tx = " + ByteUtilities.toHexString(new Long(n), 8));
            n = dataInputStream.readInt();
            printWriter.println("IP Packets Rx = " + ByteUtilities.toHexString(new Long(n), 8));
            n = dataInputStream.readInt();
            printWriter.println("IP Packets Tx = " + ByteUtilities.toHexString(new Long(n), 8));
            n = dataInputStream.readInt();
            printWriter.println("IP Packets Acked = " + ByteUtilities.toHexString(new Long(n), 8));
            n = dataInputStream.readInt();
            printWriter.println("Dropped Tx Packets = " + ByteUtilities.toHexString(new Long(n), 8));
            n = dataInputStream.readInt();
            printWriter.println("Echo Packets = " + ByteUtilities.toHexString(new Long(n), 8));
            n = dataInputStream.readInt();
            printWriter.println("reserved0 = " + ByteUtilities.toHexString(new Long(n), 8));
            long l = dataInputStream.readLong();
            printWriter.println("Last Echo = " + ByteUtilities.toHexString(new Long(l), 16));
            n = dataInputStream.readInt();
            printWriter.println("Command Packets Rx = " + ByteUtilities.toHexString(new Long(n), 8));
            n = dataInputStream.readInt();
            printWriter.println("Invalid Packets Rx = " + ByteUtilities.toHexString(new Long(n), 8));
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    static {
        Properties properties = new Properties();
        long l = 200L;
        try {
            properties.load(new FileInputStream(TIMEOUT_PROPS_FILE));
            String string = properties.getProperty(TIMEOUT_SURV_KEY);
            if (string != null) {
                try {
                    l = Long.parseLong(string);
                    System.err.println("Timeout overridden: " + l + " seconds.");
                }
                catch (Exception exception) {
                    System.err.println("Unable to parse Os400ConsoleConnMonitoringInSec value \"" + string + "\", defaulting to " + 200L + " seconds.");
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (l < 6L) {
            l = 6L;
        }
        SURVEILLANCE_INTERVAL_SEC = l;
        SURVEILLANCE_INTERVAL_MS = SURVEILLANCE_INTERVAL_SEC * 1000L;
        s_allowRoot = false;
        s_useCIM = true;
        logTrace = true;
        logComm = true;
        logCIMExceptions = false;
        outputPrintStream = System.out;
        asyncPrintStream = System.err;
    }

    public final class UPMapEntry {
        private String m_u;
        private String m_p;
        private BitSet m_caps;
        private VSerialInfoClient m_client;

        public UPMapEntry(String string, String string2) {
            this.m_u = string;
            this.m_p = string2;
        }

        public String getU() {
            return this.m_u;
        }

        public String getP() {
            return this.m_p;
        }

        public BitSet getCaps() {
            return this.m_caps;
        }

        public void setCaps(BitSet bitSet) {
            this.m_caps = bitSet;
        }

        public VSerialInfoClient getClient() {
            return this.m_client;
        }

        public void setClient(VSerialInfoClient vSerialInfoClient) {
            this.m_client = vSerialInfoClient;
        }
    }

    public class CorrelationTokenMapEntry {
        public VSerialSessionIfc session;
        public HardwareServerMessage message;

        public CorrelationTokenMapEntry(VSerialSessionIfc vSerialSessionIfc, HardwareServerMessage hardwareServerMessage) {
            this.session = vSerialSessionIfc;
            this.message = hardwareServerMessage;
        }
    }

    class SLICSurveillanceTask
    implements Runnable {
        SLICSurveillanceTask() {
        }

        public void run() {
            block4: while (true) {
                Date date = new Date();
                long l = date.getTime();
                try {
                    Thread.sleep(SURVEILLANCE_INTERVAL_MS / 2L);
                    Vector vector = VSerialHelper.this.getSurveillanceKeyList();
                    int n = 0;
                    while (true) {
                        if (n >= vector.size()) continue block4;
                        Long l2 = (Long)vector.get(n);
                        long l3 = l2;
                        Date date2 = VSerialHelper.this.getSurveillanceDate(l2);
                        if (date2 == null) {
                            int n2 = (int)(l3 >> 32 & 0xFFFFFFFFFFFFFFFFL);
                            short s = (short)(l3 >> 16 & 0xFFFFL);
                            short s2 = (short)(l3 & 0xFFFFL);
                            byte[] byArray = date.toString().getBytes();
                            try {
                                VSerialHelper.this.sendSlicEcho(n2, s, s2, 0xFFFFFF, byArray);
                                VSerialHelper.this.setSurveillanceDate(l2, date);
                            }
                            catch (IOException iOException) {
                                VSerialHelper.logError(0xFFFFFFL, 65531L, Long.toHexString(l3) + " surveilance send failed");
                                VSerialHelper.this.stopSurveillance(l2);
                            }
                        } else if (l - date2.getTime() > SURVEILLANCE_INTERVAL_MS) {
                            VSerialHelper.this.stopSurveillance(l2);
                            VSerialHelper.logError(0xFFFFFFL, 65531L, Long.toHexString(l3) + " surveilance timed out");
                        }
                        ++n;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

